/*
 * Decompiled with CFR 0.152.
 */
package dev.engine_room.flywheel.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import dev.engine_room.flywheel.api.backend.Backend;
import dev.engine_room.flywheel.api.backend.BackendManager;
import dev.engine_room.flywheel.backend.BackendConfig;
import dev.engine_room.flywheel.backend.FlwBackend;
import dev.engine_room.flywheel.backend.compile.LightSmoothness;
import dev.engine_room.flywheel.impl.FlwConfig;
import dev.engine_room.flywheel.impl.FlwImpl;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.nio.file.Path;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_151;
import net.minecraft.class_2960;
import net.minecraft.class_3532;

public class FabricFlwConfig
implements FlwConfig {
    public static final Path PATH = FabricLoader.getInstance().getConfigDir().resolve("flywheel.json");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final boolean LIMIT_UPDATES_DEFAULT = true;
    public static final int WORKER_THREADS_DEFAULT = -1;
    public static final int WORKER_THREADS_MAX = Runtime.getRuntime().availableProcessors();
    public static final FabricFlwConfig INSTANCE = new FabricFlwConfig(PATH.toFile());
    private final File file;
    public Backend backend = BackendManager.offBackend();
    public boolean useDefaultBackend = true;
    public boolean limitUpdates = true;
    public int workerThreads = -1;
    public final FabricBackendConfig backendConfig = new FabricBackendConfig();

    public FabricFlwConfig(File file) {
        this.file = file;
    }

    @Override
    public Backend backend() {
        if (this.useDefaultBackend) {
            return BackendManager.defaultBackend();
        }
        return this.backend;
    }

    @Override
    public boolean limitUpdates() {
        return this.limitUpdates;
    }

    @Override
    public int workerThreads() {
        return this.workerThreads;
    }

    @Override
    public BackendConfig backendConfig() {
        return this.backendConfig;
    }

    public void load() {
        if (this.file.exists()) {
            try (FileReader reader = new FileReader(this.file);){
                this.fromJson(JsonParser.parseReader((Reader)reader));
            }
            catch (Exception e) {
                FlwImpl.CONFIG_LOGGER.warn("Could not load config from file '{}'", (Object)this.file.getAbsolutePath(), (Object)e);
            }
        }
        this.save();
    }

    public void save() {
        try (FileWriter writer = new FileWriter(this.file);){
            GSON.toJson((JsonElement)this.toJson(), (Appendable)writer);
        }
        catch (Exception e) {
            FlwImpl.CONFIG_LOGGER.warn("Could not save config to file '{}'", (Object)this.file.getAbsolutePath(), (Object)e);
        }
    }

    public void fromJson(JsonElement json) {
        if (!(json instanceof JsonObject)) {
            FlwImpl.CONFIG_LOGGER.warn("Config JSON must be an object");
            this.backend = BackendManager.offBackend();
            this.useDefaultBackend = true;
            this.limitUpdates = true;
            this.workerThreads = -1;
            return;
        }
        JsonObject object = (JsonObject)json;
        this.readBackend(object);
        this.readLimitUpdates(object);
        this.readWorkerThreads(object);
        this.readFlwBackends(object);
    }

    private void readBackend(JsonObject object) {
        JsonPrimitive primitive;
        JsonElement backendJson = object.get("backend");
        Object msg = null;
        if (backendJson instanceof JsonPrimitive && (primitive = (JsonPrimitive)backendJson).isString()) {
            String value = primitive.getAsString();
            if (value.equals("DEFAULT")) {
                this.backend = BackendManager.offBackend();
                this.useDefaultBackend = true;
                return;
            }
            try {
                this.backend = Backend.REGISTRY.getOrThrow(new class_2960(value));
                this.useDefaultBackend = false;
                return;
            }
            catch (class_151 e) {
                msg = "'backend' value '" + value + "' is not a valid resource location";
            }
            catch (IllegalArgumentException e) {
                msg = "Backend with ID '" + value + "' is not registered";
            }
            catch (Exception e) {
                msg = "'backend' value '" + value + "' is invalid";
            }
        } else if (backendJson != null) {
            msg = "'backend' value must be a string";
        }
        if (msg != null) {
            FlwImpl.CONFIG_LOGGER.warn((String)msg);
        }
        this.backend = BackendManager.offBackend();
        this.useDefaultBackend = true;
    }

    private void readLimitUpdates(JsonObject object) {
        JsonPrimitive primitive;
        JsonElement limitUpdatesJson = object.get("limitUpdates");
        if (limitUpdatesJson instanceof JsonPrimitive && (primitive = (JsonPrimitive)limitUpdatesJson).isBoolean()) {
            this.limitUpdates = primitive.getAsBoolean();
            return;
        }
        if (limitUpdatesJson != null) {
            FlwImpl.CONFIG_LOGGER.warn("'limitUpdates' value must be a boolean");
        }
        this.limitUpdates = true;
    }

    private void readWorkerThreads(JsonObject object) {
        JsonPrimitive primitive;
        JsonElement workerThreadsJson = object.get("workerThreads");
        if (workerThreadsJson instanceof JsonPrimitive && (primitive = (JsonPrimitive)workerThreadsJson).isNumber()) {
            int value = primitive.getAsInt();
            int clamped = class_3532.method_15340((int)value, (int)-1, (int)WORKER_THREADS_MAX);
            if (clamped != value) {
                FlwImpl.CONFIG_LOGGER.warn("'workerThreads' value of {} is out of range, clamping to {}", (Object)value, (Object)clamped);
            }
            this.workerThreads = clamped;
            return;
        }
        if (workerThreadsJson != null) {
            FlwImpl.CONFIG_LOGGER.warn("'workerThreads' value must be an integer");
        }
        this.workerThreads = -1;
    }

    private void readFlwBackends(JsonObject object) {
        JsonElement flwBackendsJson = object.get("flw_backends");
        if (flwBackendsJson instanceof JsonObject) {
            JsonObject flwBackendsObject = (JsonObject)flwBackendsJson;
            this.backendConfig.fromJson(flwBackendsObject);
        } else {
            FlwImpl.CONFIG_LOGGER.warn("'flw_backends' value must be an object");
        }
    }

    public JsonObject toJson() {
        JsonObject object = new JsonObject();
        object.addProperty("backend", this.useDefaultBackend ? "DEFAULT" : Backend.REGISTRY.getIdOrThrow(this.backend).toString());
        object.addProperty("limitUpdates", Boolean.valueOf(this.limitUpdates));
        object.addProperty("workerThreads", (Number)this.workerThreads);
        object.add("flw_backends", (JsonElement)this.backendConfig.toJson());
        return object;
    }

    public static class FabricBackendConfig
    implements BackendConfig {
        public static final LightSmoothness LIGHT_SMOOTHNESS_DEFAULT = LightSmoothness.SMOOTH;
        public LightSmoothness lightSmoothness = LIGHT_SMOOTHNESS_DEFAULT;

        @Override
        public LightSmoothness lightSmoothness() {
            return this.lightSmoothness;
        }

        public void fromJson(JsonObject object) {
            this.readLightSmoothness(object);
        }

        private void readLightSmoothness(JsonObject object) {
            JsonPrimitive primitive;
            JsonElement lightSmoothnessJson = object.get("lightSmoothness");
            Object msg = null;
            if (lightSmoothnessJson instanceof JsonPrimitive && (primitive = (JsonPrimitive)lightSmoothnessJson).isString()) {
                String value = primitive.getAsString();
                for (LightSmoothness item : LightSmoothness.values()) {
                    if (!item.name().equalsIgnoreCase(value)) continue;
                    this.lightSmoothness = item;
                    return;
                }
                msg = "Unknown 'lightSmoothness' value: " + value;
            } else if (lightSmoothnessJson != null) {
                msg = "'lightSmoothness' value must be a string";
            }
            if (msg != null) {
                FlwBackend.LOGGER.warn((String)msg);
            }
            this.lightSmoothness = LIGHT_SMOOTHNESS_DEFAULT;
        }

        public JsonObject toJson() {
            JsonObject object = new JsonObject();
            object.addProperty("lightSmoothness", this.lightSmoothness.method_15434());
            return object;
        }
    }
}

